
import os
import pandas as pd
import wandb
import sys
import warnings

sys.path.append('/home/ADBench')

from data_generator import DataGenerator
from myutils import Utils
import re
import gama
from gama import GamaClassifier
from gama.search_methods import RandomSearch, AsynchronousSuccessiveHalving
from pyod.models.iforest import IForest
from sklearn.decomposition import FastICA
from pyod.models.iforest import IForest
from sklearn.pipeline import Pipeline
from sklearn.impute import SimpleImputer
import ott
from pyod.models.lof import LOF
from pyod.models.ocsvm import OCSVM
from pyod.models.knn import KNN
from pyod.models.hbos import HBOS
from pyod.models.abod import ABOD
from pyod.models.loda import LODA
from pyod.models.cof import COF
from pyod.models.cblof import CBLOF
from pyod.models.cd import CD


anchor_dataset=""
ica=FastICA()
data_list.remove(anchor_dataset)
datagenerator.dataset = anchor_dataset # specify the dataset name
anchor_data = datagenerator.generator(la=0.3, realistic_synthetic_mode='local', noise_type='duplicated_anomalies')
x = ica.fit_transform(anchor_data['X_train'])
distances = dict()
for dataset in data_list:
    datagenerator.dataset = dataset # specify the dataset name
    data = datagenerator.generator(la=0.3, realistic_synthetic_mode='local', noise_type='duplicated_anomalies')
    y = ica.fit_transform(data['X_train'])

    geom_xx = ott.geometry.pointcloud.PointCloud(x)
    geom_yy = ott.geometry.pointcloud.PointCloud(y)

    # below `z` is there only to create n x m geometry
    prob = ott.core.quad_problems.QuadraticProblem(
        geom_xx, geom_yy
    )
    solver = ott.core.gromov_wasserstein.GromovWasserstein(rank=6)
    ot_gwlr = solver(prob)
#    print(f"GWLR = {ot_gwlr.costs[ot_gwlr.costs > 0][-1]}")
    distances[dataset] = ot_gwlr.costs[ot_gwlr.costs > 0][-1]

